<?php $__env->startSection('content'); ?>
<div class="main-panel">
    <div class="content">
        <div class="container-fluid">
            <form action="<?php echo e(route('data.update', $data->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Edit Berita</h4>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">Judul</label>
                                    <input required value="<?php echo e($data->title); ?>" type="text" class="form-control" id="title" name="title" placeholder="Masukkan Judul" required>
                                </div>

                                <?php if(session('error')): ?>
                                            <div class="alert alert-danger" id="error-alert">
                                                <?php echo e(session('error')); ?>

                                            </div>
                                            <script>
                                                setTimeout(function() {
                                                    document.getElementById('error-alert').style.display = 'none';
                                                }, 3000);
                                            </script>
                                        <?php endif; ?>

                                <div class="form-group">
                                    <label for="photo">Gambar</label>
                                    <div class="custom-file">
                                        <input type="file" name="photo" accept=".jpg, .jpeg, .png" class="custom-file-input" id="photo" onchange="previewImage(event)" value="<?php echo e($data->photo); ?>">
                                        <label class="custom-file-label" for="photo" id="photoLabel"><?php echo e($data->photo ? $data->photo : 'Pilih Gambar'); ?></label>
                                    </div>
                                    <div class="mt-3 d-flex align-items-center">
                                        <div style="width: 100px; height: 100px;">
                                            <img src="<?php echo e(asset('storage/img/' . $data->photo)); ?>" id="imagePreview" style="width: 100%; height: 100%; object-fit: cover;" />
                                        </div>
                                        <button type="button" class="btn btn-danger ml-2" onclick="clearImage()">Hapus</button>
                                    </div>
                                </div>

                                <script>
                                    function previewImage(event) {
                                        var reader = new FileReader();
                                        reader.onload = function(){
                                            var output = document.getElementById('imagePreview');
                                            output.src = reader.result;
                                            document.getElementById('photoLabel').innerText = 'Gambar Dipilih';
                                        };
                                        reader.readAsDataURL(event.target.files[0]);
                                    }

                                    function clearImage() {
                                        var fileInput = document.getElementById('photo');
                                        var imagePreview = document.getElementById('imagePreview');
                                        var photoLabel = document.getElementById('photoLabel');
                                        fileInput.value = '';
                                        imagePreview.src = '';
                                        photoLabel.innerText = 'Pilih Gambar';
                                    }
                                </script>

                                <div class="form-group">
                                    <label for="deskripsi">Deskripsi</label>
                                    <textarea required class="form-control" style="height: 200px" type="text" class="form-control" id="deskripsi" name="deskripsi" placeholder="Masukkan deskripsi" required><?php echo e($data->data); ?></textarea>
                                </div>

                                <div class="form-group">
                                    <label for="tags">Tags</label>
                                    <input required value="<?php echo e($data->tags); ?>" type="text" class="form-control" id="tags" name="tags" placeholder="Masukkan Tags" required>
                                </div>

                                

                            </div>

                            <div class="card-footer d-flex justify-content-between">
                                <button type="button" class="btn btn-primary">
                                    <a class="text-decoration-none text-white" href="/admin/dashboard" style="text-decoration: none;">Back</a>
                                </button>
                                <button type="submit" class="btn btn-success">Edit</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\ROED\2025\UPTpasar_laravel\website\upt\resources\views/admin/update.blade.php ENDPATH**/ ?>