@extends('index')

@section('content')
<section class="berita-page-section theTop container">
        <h1 class="text-center" style="text-transform: uppercase;">Tag: {{ $dataTag }}</h1>
        <br>
        <div class="row">
            <!-- First Card -->
            @foreach($data as $data1)
            <div class="col-md-4 d-flex" style="margin-bottom: 20px">
            <div class="card" style="
            box-shadow: 0 2px 5px rgba(0,0,0,.2);
            display: flex;
            flex-direction: column;
            ">
            <img src="{{ asset('storage/img/' . $data1->photo) }}" style=" object-fit: cover; max-height: 250px; min-height: 250px;" class="card-img-top" alt="Berita Image">
                <div class="card-body d-flex flex-column" style="padding: 5%;">
                    <h5 class="card-title" title="{{ $data1->title }}">{{ $data1->title }}</h5>
                    <br>
                    <p class="card-text" style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis; cursor: default;">
                        {{ \Illuminate\Support\Str::words($data1->data, 10, '...') }}
                    </p>
                    <br>
                    <a class="text-decoration-none text-primary mt-auto" href="/berita/{{ $data1->slug }}" style="text-decoration: none; font-size: 14px;">BACA SELENGKAPNYA »</a>
                    <hr>
                    <p class="card-text" style="cursor: default;">{{ \Carbon\Carbon::parse($data1->created_at)->locale('id')->isoFormat('D MMMM YYYY') }}</p>
                </div>
            </div>
            </div>
            @endforeach
        </div>
        <br>
        <div class="pagination-container text-center d-flex justify-content-center align-items-center">
            @if ($data->onFirstPage())
                <button class="btn btn-secondary" style="margin-right: 20px" disabled>Selanjutnya</button>
            @else
                <a href="{{ $data->previousPageUrl() }}" class="btn btn-primary" style="margin-right: 20px">Selanjutnya</a>
            @endif
            <span class="mx-3 text-center">
                Menampilkan Total {{ $data->firstItem() }} - {{ $data->lastItem() }} dari {{ $data->total() }} Berita
            </span>
            @if ($data->hasMorePages())
                <a href="{{ $data->nextPageUrl() }}" class="btn btn-primary" style="margin-left: 20px">Sebelumnya</a>
            @else
                <button class="btn btn-secondary" style="margin-left: 20px" disabled>Sebelumnya</button>
            @endif
        </div>
</section>

@stop
