@extends('index')

@section('content')
<section class="artikel theTop container">
    <div class="d-flex justify-content-between">
        <div class="col-md-9">
            <div class="dataArtikel">
                <h1 class="header text-center">{{ $data->title }}</h1>
                <p class="text-center">{{ \Carbon\Carbon::parse($data->created_at)->locale('id')->isoFormat('D MMMM YYYY') }}</p>
                <br>
                <img src="{{ asset('storage/img/' . $data->photo) }}" alt="gambar artikel">
                <div class="card-body3" style="height: auto;">
                    <p style="color:  #505057;">{!! nl2br(e($data->data)) !!}</p>
                </div>
            </div>
            <div class="tagArtikel">
                <h4>Tags: </h4>
                @foreach(explode(',', $data->tags) as $tag)
                    <button><a href="/berita/tags/{{ trim($tag) }}">{{ trim($tag) }}</a></button>
                @endforeach
            </div>
        </div>


        <div class="divBeritaTerbaru col-md-3">
            <h3 class="text-center">Berita Terbaru</h3>
            <br>
            @foreach ($dataBerita as $berita)
            <div class="beritaTerbaru">
                <img src="{{ asset('storage/img/' . $berita->photo) }}" alt="berita">
                <a href="/berita/{{ $berita->slug }}" class="text-decoration-none">
                    <h2>{{ $berita->title }}</h2>
                    <p>{{ \Carbon\Carbon::parse($berita->created_at)->locale('id')->isoFormat('D MMMM YYYY') }}</p>
                </a>
            </div>
            <br>
            @endforeach
        </div>
    </div>
</section>

@stop
