@extends('admin.dashboard')

@section('content')
<div class="main-panel">
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-tasks">

                        <div class="card-header col-md-12 d-flex justify-content-between align-items-center">
                            <h4 class="card-title">Data Berita</h4>
                            <form class="navbar-right navbar-form nav-search" class="form-inline" method="GET" action="/admin/dashboard/">
                                <div class="input-group">
                                    <input type="search" id="searchTable" name="searchTable" placeholder="Cari..." aria-label="search" value="{{ request()->get('searchTable') }}" class="form-control">
                                    <div class="input-group-append">
                                        <button class="border-0" type="submit" style="outline: none; box-shadow: none; background: transparent;">
                                            <i class="la la-search search-icon"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <div id="lookup" style="padding: 15px 15px;" class="text-right">
                            <form action="/admin/dashboard" method="GET">
                                <button class="btn btn-outline-success my-sm-0" type="submit">
                                    <i class="la la-refresh" style="font-size: 1.5em;"></i>
                                </button>
                            </form>
                        </div>


                        <div class="card-body">
                            <div class="table-full-width" style="overflow-y: scroll; overflow-x:auto;">
                                <table class="table table-bordered" id="dataTable">
                                    <thead class="text-center">
                                        <tr>
                                            <th>No</th>
                                            <th>Judul</th>
                                            <th>Gambar</th>
                                            <th>Deskripsi</th>
                                            <th>Tag</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($data as $index => $dt)
                                        <tr>
                                            <td>{{ $loop->iteration + ($data->currentPage() - 1) * $data->perPage() }}</td>

                                            <td style="width: 20%">{{ $dt->title }}</td>

                                            <td style="width: 10%" class="text-center"><img src="{{ asset('storage/img/'.$dt->photo) }}" style="object-fit: cover;" width="50" height="50"></td>

                                            <td style="
                                            width: 40%;"><textarea class="form-control"  rows="3">{{ $dt->data }}</textarea></td>

                                            <td style="width: 20%" class="text-center">{{ $dt->tags }} </td>

                                            <td style="width: 10%" class="td-actions text-center">
                                                <div class="form-button-action">

                                                    <a href="{{ route('data.edit', $dt->id) }}" data-toggle="tooltip" title="Edit Data" class="btn btn-link btn-simple-primary">
                                                        <i class="la la-edit"></i>
                                                    </a>

                                                    <form method="POST" action="{{ route('data.destroy', $dt->id) }}" onsubmit="return confirm('Hapus Data?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" data-toggle="tooltip" title="hapus" class="btn btn-link btn-simple-danger">
                                                            <i class="la la-times"></i>
                                                        </button>
                                                    </form>

                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                            </div>
                            <div class="pagination-container d-flex justify-content-center align-items-center">
                                @if ($data->onFirstPage())
                                    <button class="btn btn-secondary" disabled>Selanjutnya</button>
                                @else
                                    <a href="{{ $data->previousPageUrl() }}" class="btn btn-primary">Selanjutnya</a>
                                @endif

                                <span class="mx-3 text-center">
                                    Menampilkan Total {{ $data->firstItem() }} - {{ $data->lastItem() }} dari {{ $data->total() }} Data
                                </span>

                                @if ($data->hasMorePages())
                                    <a href="{{ $data->nextPageUrl() }}" class="btn btn-primary">Sebelumnya</a>
                                @else
                                    <button class="btn btn-secondary" disabled>Sebelumnya</button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <form action="{{ url('data') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Berita Baru</h4>
                                        {{-- <p class="card-category">Lorem Ipsum</p> --}}
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="title">Judul</label>
                                            <input type="text" class="form-control" id="title" name="title" placeholder="Masukkan Judul" required>
                                        </div>

                                        @if (session('error'))
                                            <div class="alert alert-danger" id="error-alert">
                                                {{ session('error') }}
                                            </div>
                                            <script>
                                                alert('JUDUL BERITA SUDAH ADA');
                                                setTimeout(function() {
                                                    document.getElementById('error-alert').style.display = 'none';
                                                }, 5000);
                                            </script>
                                        @endif

                                        <div class="form-group">
                                            <label for="photo">Gambar</label>
                                            <div class="custom-file">
                                                <input type="file" name="photo" class="custom-file-input" accept=".jpg, .jpeg, .png" id="photo" required onchange="previewImage(event)">
                                                <label class="custom-file-label" for="photo" id="photoLabel">Pilih Gambar</label>
                                            </div>
                                            <div class="mt-3 d-flex align-items-center">
                                                <div style="width: 100px; height: 100px;">
                                                    <img id="imagePreview" style="width: 100%; height: 100%; object-fit: cover;" />
                                                </div>
                                                <button type="button" class="btn btn-danger ml-2" onclick="clearImage()">Hapus</button>
                                            </div>
                                        </div>

                                        <script>
                                            function previewImage(event) {
                                                var reader = new FileReader();
                                                reader.onload = function(){
                                                    var output = document.getElementById('imagePreview');
                                                    output.src = reader.result;
                                                    document.getElementById('photoLabel').innerText = 'Gambar Dipilih';
                                                };
                                                reader.readAsDataURL(event.target.files[0]);
                                            }

                                            function clearImage() {
                                                var fileInput = document.getElementById('photo');
                                                var imagePreview = document.getElementById('imagePreview');
                                                var photoLabel = document.getElementById('photoLabel');
                                                fileInput.value = '';
                                                imagePreview.src = '';
                                                photoLabel.innerText = 'Pilih Gambar';
                                            }
                                        </script>

                                        <div class="form-group">
                                            <label for="deskripsi">Deskripsi</label>
                                            <textarea style="height: 200px" type="text" class="form-control" id="deskripsi" name="deskripsi" placeholder="Masukkan deskripsi" required></textarea>
                                        </div>

                                        <div class="form-group">
                                            <label for="tags">Tag (pisah menggunakan tanda koma)</label>
                                            <input type="text" class="form-control" id="tags" name="tags" placeholder="Contoh UMKM, Pertanian, Ekonomi..." required>
                                        </div>

                                    </div>

                                    <div class="card-footer text-right">
                                        <button type="submit" class="btn btn-primary">Simpan</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
                <br>
            </div>
        </div>
    </div>
</div>
@stop
