<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfilController extends Controller
{
    function index(){
        $data = User::first();
        return view('admin.profile.profile', compact('data'));
    }

    function update(Request $request, $id)
    {
        $data = User::find($id);

        $request->validate([
            'password_lama' => 'required|string|max:255',
            'password_baru' => 'required|string|max:255',
        ]);

        if (Hash::check($request->password_lama, $data->password)) {
            $data->password = Hash::make($request->password_baru);
            $data->save();
        } else {
            return redirect()->back()->with('error', 'PASSWORD SALAH');
        }

        return redirect('/admin/dashboard')->with('success', 'Data berhasil diedit');
    }
}
